/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.dao.impl.TestSectionDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.TestSectionVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.TestCompiler;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.gui.wizard.ActivityMainPanel;
import com.quantumdata.sct.gui.wizard.NoTestSelectedException;
import com.quantumdata.sct.gui.wizard.TestSectionPage;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Vector;

public class TestWizard
extends ActivityMainPanel {
    public TestWizard(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI);
    }

    public void initTestSections(String string) throws Exception {
        this.clearCards();
        Collection collection = TestCompiler.instance().compileTests(string);
        if (collection.isEmpty()) {
            throw new NoTestSelectedException("Test compiler did not generate any test based on selected options");
        }
        TestSectionDAO testSectionDAO = (TestSectionDAO)XMLDAOFactory.getTestSectionDAO();
        IPersistable[] iPersistableArray = testSectionDAO.readAll();
        for (int i = 0; i < iPersistableArray.length; ++i) {
            Object object2;
            TestSectionVO testSectionVO = (TestSectionVO)iPersistableArray[i];
            Vector<Object> vector = new Vector<Object>(testSectionVO.size());
            for (Object object2 : collection) {
                if (!testSectionVO.contains(((TestVO)object2).getId())) continue;
                vector.add(object2);
            }
            if (vector.isEmpty()) continue;
            object2 = new TestSectionPage(testSectionVO, vector);
            this.addCard(testSectionVO.getName(), (ActivityCardItemPanel)object2);
        }
        this.validateBtn();
    }

    public void validateBtn() {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        String string = "Test : " + (testSectionPage.getTestIndex() + 1) + " of " + testSectionPage.getTestCount();
        this.getStepCountButton().setText(string);
        if (this.isFirstPage()) {
            this.getSecBackButton().setEnabled(false);
        } else {
            this.getSecBackButton().setEnabled(true);
        }
        if (this.isLastPage()) {
            this.getSecNextButton().setEnabled(false);
        } else {
            this.getSecNextButton().setEnabled(true);
        }
        if (this.isFirstPage() && this.isFirstTest()) {
            this.getCancelButton().setEnabled(false);
        } else {
            this.getCancelButton().setEnabled(true);
        }
        if (this.isLastPage() && this.isLastTest()) {
            this.getFinishButton().setEnabled(false);
        } else {
            this.getFinishButton().setEnabled(true);
        }
        if (this.isFirstStep()) {
            this.getBackButton().setEnabled(false);
        } else {
            this.getBackButton().setEnabled(true);
        }
        if (this.isLastStep()) {
            this.getNextButton().setEnabled(false);
        } else {
            this.getNextButton().setEnabled(true);
        }
    }

    private boolean isFirstTest() {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        return testSectionPage.isFirstTest();
    }

    private boolean isLastTest() {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        return testSectionPage.isLastTest();
    }

    private boolean isFirstStep() {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        return testSectionPage.isFirstStep();
    }

    private boolean isLastStep() {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        return testSectionPage.isLastStep();
    }

    public void nextSecButtonAction(ActionEvent actionEvent) {
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        testSectionPage.setLastIndex();
        super.nextSecButtonAction(actionEvent);
        this.validateBtn();
    }

    public void backSecButtonAction(ActionEvent actionEvent) {
        super.backSecButtonAction(actionEvent);
        TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
        testSectionPage.setFirstIndex();
        this.validateBtn();
    }

    public void nextButtonAction(ActionEvent actionEvent) {
        if (this.updateSys()) {
            TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
            if (testSectionPage.nextButtonAction(actionEvent)) {
                super.nextButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    public void cancelButtonAction(ActionEvent actionEvent) {
        if (this.updateSys()) {
            TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
            if (testSectionPage.cancelButtonAction(actionEvent)) {
                super.backButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    public void finishButtonAction(ActionEvent actionEvent) {
        if (this.updateSys()) {
            TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
            if (testSectionPage.finishButtonAction(actionEvent)) {
                super.nextButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    public void backButtonAction(ActionEvent actionEvent) {
        if (this.updateSys()) {
            TestSectionPage testSectionPage = (TestSectionPage)this.getCurrentCard();
            if (testSectionPage.backButtonAction(actionEvent)) {
                super.backButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    protected SCTButton getFinishButton() {
        SCTButton sCTButton = super.getFinishButton();
        sCTButton.setText("Test>");
        sCTButton.setMnemonic('F');
        return sCTButton;
    }

    protected SCTButton getCancelButton() {
        SCTButton sCTButton = super.getCancelButton();
        sCTButton.setText("<Test");
        sCTButton.setMnemonic('C');
        return sCTButton;
    }

    protected SCTButton getNextButton() {
        SCTButton sCTButton = super.getNextButton();
        sCTButton.setText("Step>");
        sCTButton.setMnemonic('N');
        return sCTButton;
    }

    protected SCTButton getBackButton() {
        SCTButton sCTButton = super.getBackButton();
        sCTButton.setText("Reset Test");
        sCTButton.setMnemonic('B');
        return sCTButton;
    }

    protected boolean updateSys() {
        if (SCTSelection.instance().getCurrentConnection() == null) {
            return false;
        }
        TEInterface tEInterface = TEInterface.instance();
        if (!tEInterface.m_instrument.isConnected()) {
            return false;
        }
        try {
            String string = "LIC";
            String string2 = "TME";
            String string3 = tEInterface.executeQueryWaitForResponse(string + "X:" + string + "Q? " + string2, 5);
            if (Integer.parseInt(string3) != 1) {
                this.toolUI.setVisible(false);
                MessageOptionPane.ShowErrorMessage(this.toolUI, "The Quantum Data equipment is not registered to use the TME.  Please contact Quantum Data for registration details.", "ERROR!");
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

